% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThresholdSummary.R
\name{getThresholdSummary}
\alias{getThresholdSummary}
\title{Calculate all measures for sparse ROC}
\usage{
getThresholdSummary(
  prediction,
  predictionType = "binary",
  typeColumn = "evaluation"
)
}
\arguments{
\item{prediction}{A prediction object}

\item{predictionType}{The type of prediction (binary or survival)}

\item{typeColumn}{A column that is used to stratify the results}
}
\value{
A data.frame with TP, FP, TN, FN, TPR, FPR, accuracy, PPF, FOR and Fmeasure
}
\description{
Calculate all measures for sparse ROC
}
\details{
Calculates the TP, FP, TN, FN, TPR, FPR, accuracy, PPF, FOR and Fmeasure
from a prediction object
}
\examples{
prediction <- data.frame(rowId = 1:100, 
                         outcomeCount = stats::rbinom(1:100, 1, prob=0.5),
                         value = runif(100), 
                         evaluation = rep("Train", 100))
summary <- getThresholdSummary(prediction)
str(summary)
}
