% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_PLSModel.R
\name{PLSModel}
\alias{PLSModel}
\title{Partial Least Squares Model}
\usage{
PLSModel(ncomp = 1, scale = FALSE)
}
\arguments{
\item{ncomp}{number of components to include in the model.}

\item{scale}{logical indicating whether to scale the predictors by the
sample standard deviation.}
}
\value{
\code{MLModel} class object.
}
\description{
Function to perform partial least squares regression.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}}
\item{\link[=tune]{Automatic Tuning} Grid Parameters:}{
  \code{ncomp}
}
}

Further model details can be found in the source link below.
}
\examples{
library(MASS)

fit(medv ~ ., data = Boston, model = PLSModel())

}
\seealso{
\code{\link[pls]{mvr}}, \code{\link{fit}}, \code{\link{resample}},
\code{\link{tune}}
}
