% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_olden}
\alias{plot_olden}
\title{Plotting Olden Values Barplot}
\usage{
plot_olden(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with
'sensitivity_analysis(methods = "Olden")'.}

\item{show_table}{Boolean. Whether to print Olden results table.}
}
\value{
analysis_object
}
\description{
The \strong{plot_olden()} function visualizes Olden sensitivity values computed
from products of input-to-hidden layer connection weights and
hidden-to-output layer connection weights for each feature. Provides relative
feature importance rankings specific to feedforward Neural Networks based on
synaptic weight magnitude and directionality analysis across network layers.
}
\examples{
# Note: For obtaining the Olden plot the user needs to complete till
# sensitivity_analysis( ) function of the MLwrap pipeline using the Olden
# method.
# See the full pipeline example under sensitivity_analysis()
# (Requires sensitivity_analysis(methods = "Olden"))
# Final call signature:
# plot_olden(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
