% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_DE_3_PctASE.R
\name{PctASE}
\alias{PctASE}
\title{Tabulate differentially spliced splicing event}
\usage{
PctASE(
  MarvelObject,
  method,
  psi.pval,
  psi.mean.diff,
  ylabels.size = 8,
  barlabels.size = 3,
  x.offset = 0,
  direction.color = NULL,
  mode = "percentage"
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues} function.}

\item{method}{Character string. The statistical method used for differential splicing analysis.}

\item{psi.pval}{Numeric value. Adjusted p-value below which the splicing event is considered differentially spliced and included for tabulation.}

\item{psi.mean.diff}{Numeric value. The minimum absolute differences in PSI values between the two cell groups above which the splicing event is considered differentially spliced and included for tabulation.}

\item{ylabels.size}{Numeric value. Size of the xtick labels. Default is \code{8}.}

\item{barlabels.size}{Numeric value. Size of the labels above each bar. Default is \code{3}}

\item{x.offset}{Numeric value. The values on the x-axis to offset by. Useful when right margin overshadow the numbers above the bars. Default value is \code{0}.}

\item{direction.color}{Character strings. Vector of length 2 to specify the colors for significanly down- and up-regulated splicing events. Default is \code{NULL}, which corresponds to default \code{ggplot2} color scheme.}

\item{mode}{Character strings. When set to \code{"percentage"} (default), percentage of significant splicing events over total splicing events detected will be tabulate. When set to \code{absolute}, the number of significant splicing events will be tabulated.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$DE$AbsASE$Table} and \code{MarvelObject$DE$AbsASE$Plot}.
}
\description{
Tabulates the percentage or absoluate number of significant splicing events for each splicing type.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- PctASE(MarvelObject=marvel.demo,
                      method="ad",
                      psi.pval=0.1,
                      psi.mean.diff=0
                      )
}
