% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_DE_6_1_GO.R
\name{BioPathways}
\alias{BioPathways}
\title{Pathway enrichment analysis}
\usage{
BioPathways(
  MarvelObject,
  method = NULL,
  pval = NULL,
  delta = 0,
  n.top = NULL,
  method.adjust = "fdr",
  custom.genes = NULL,
  species = "human"
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues} function.}

\item{method}{Character string. The statistical method used for differential splicing analysis.}

\item{pval}{Numeric value. Alternative to \code{n.top} and \code{custom.genes}, i.e. choose one of these three options. Adjusted p-value below which the splicing events are considered differentially spliced and their corresponding genes are included for gene ontology analysis. If this argument is specified, then \code{n.top} must not be specified.}

\item{delta}{Numeric value. The absolute difference between the means PSI values of cell group 1 and 2, above which, the splicing event is considered differentially spliced and their corresponding genes are included for gene ontology analysis.}

\item{n.top}{Numeric value. Alternative to \code{pval} to \code{custom.genes}, i.e. choose one of these three options.. Indicate the top n splicing events with the smallest adjusted p-values are differentially spliced and their corresponding genes are included for gene ontology analysis. If this argument is specified, then \code{pval} must not be specified.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}

\item{custom.genes}{Character strings. Alternative to \code{pval} and \code{n.top}, i.e. choose one of these three options.. Vector of gene names to be assessed for enrichment of biological pathways.}

\item{species}{Character strings. Takes the value \code{"human"} or \code{"mouse"}, which corresponds to human and mouse genes, respectively. Default value is \code{"human"}. This will enable \code{MARVEL} to retrieve the relevant database for GO analysis.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$DE$BioPathways$Table}.
}
\description{
Performs pathway enrichment analysis on differentially spliced genes or user-specified custom set of genes.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- BioPathways(MarvelObject=marvel.demo,
                           method="ad",
                           custom.genes=c("RPL26", "SNRPN")
                           )
}
