% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repse.R
\name{repse}
\alias{repse}
\alias{repsecomp}
\alias{pvse}
\title{Standard Error for Estimates with Replicate Weights and Plausible Values}
\usage{
repse(
  er,
  e0,
  setup = NULL,
  method = c("TIMSS", "PIRLS", "ICILS", "ICCS", "PISA", "TALIS")
)

repsecomp(se)

pvse(PVse, PVe0, df = FALSE)
}
\arguments{
\item{er}{a vector or a list containing any statistic of interest
(e.g., percent, mean, variance, regression coefficient).
If it is a vector or list of \code{length==1}, the function estimates
standard errors without plausible values. If it is a list with
\code{length>1}, it estimates standard errors with plausible values.}

\item{e0}{a numeric vector or a vector containing any statistic of interest
(e.g., percent, mean, variance, regression coefficient), computed using
total weights. For scenarios without plausible values,
\code{e0} should be a single value. For scenarios with plausible values,
\code{e0} should be a vector of the same length as \code{er}.}

\item{setup}{an optional list produced by \code{\link{repsetup}}.}

\item{method}{a string indicating the name of the large-scale assessment
to determine the replication method to use. Available options are:
\code{"TIMSS"}, \code{"PIRLS"}, \code{"ICILS"}, \code{"ICCS"},
\code{"PISA"}, and \code{"TALIS"}. Note that \code{"TIMSS"} and \code{"PIRLS"}
refer to the method used from 2016 onwards.
Their method has not yet been implemented for previous cycles.}

\item{se}{a numeric vector with standard errors,
used by \code{repsecomp()} to estimate a composite standard error.}

\item{PVse}{a numeric vector containing the standard errors of the estimates of each
plausible value.}

\item{PVe0}{a numeric vector containing the point estimates of each plausible value.}

\item{df}{a logical value indicating if degrees should be calculated.}
}
\value{
the standard error.
}
\description{
Calculates the standard error given a vector or list of previous estimations.
}
\details{
The standard errors are calculated using a modifier \eqn{m}, for TIMSS
and ICILS: \eqn{m = 0.5}; for ICILS and ICCS: \eqn{m = 1}; and for PISA and TALIS:
\eqn{\frac{1}{R(1-0.5)^2}}. Depending on the statistic, one of the following
formulas is used.



The standard error not involving plausible values is calculated by:

\deqn{\sqrt{m\times \sum_{r=1}^{R}(\varepsilon_r-\varepsilon_0)^2}.}

The standard error involving plausibles values and replicate weights is calculated by:

\deqn{\sqrt{\left[ \sum_{p=1}^{P} \left( m\times \sum_{r=1}^{R}(\varepsilon_{rp}-\varepsilon_{0p})^2 \right)  \dfrac{1}{P}\right]+  \left[ \left(1+ \dfrac{1}{P} \right) \dfrac{\sum_{p=1}^{P} (\varepsilon_{0p}-\overline{\varepsilon}_{0p})^{2}}{P-1} \right]}.}

The standard error involving plausibles values without replicate weights is calculated by:

\deqn{\sqrt{  \dfrac{\sum_{p=1}^{P} SE^2_{\varepsilon_{0P}}}{P}+  \left[ \left(1+ \dfrac{1}{P} \right) \dfrac{\sum_{p=1}^{P} (\varepsilon_{0p}-\overline{\varepsilon}_{0p})^{2}}{P-1} \right]}.}


The standard error of the difference of
two statistics (\eqn{a} and \eqn{b}) from independent samples is calculated by:

\deqn{\sqrt{SE_a^{2}+SE_b^{2}}.}


The standard error of the difference of
two statistics (\eqn{a} and \eqn{b}) from dependent samples
not involving plausible values
is calculated by:

\deqn{\sqrt{m\times \sum_{r=1}^R((a_r-b_r)-(a_0-b_0))^2}.}

The standard error of the difference of
two statistics (\eqn{a} and \eqn{b}) from dependent samples
involving plausible values
is calculated by:

\deqn{\sqrt{\left[ \sum_{p=1}^{P} \left( m\times \sum_{r=1}^{R}((a_{rp}-b_{rp})-(a_{0p}-b_{0p}))^2 \right)  \dfrac{1}{P}\right]+  \left[ \left(1+ \dfrac{1}{P} \right) \dfrac{\sum_{p=1}^{P} \left((a_{0p}-b_{0p})- ( \overline{a}_{0p}-\overline{b}_{0p}) \right)^{2}}{P-1} \right]}.}

The standard error of a composite estimate is calculated by:

\deqn{\sqrt{\dfrac{\sum_{c=1}^CSE^2_{\varepsilon_c}}{C^{2}}}.}

The standard error of the difference between an element (\eqn{a}) of the composite
and the composite is calculated by:

\deqn{\sqrt{\dfrac{\sum_{c=1}^CSE^2_{\varepsilon_c}}{C^{2}}+\left(\dfrac{(C-1)^2-1}{C^2}\right)SE^2_a}.}



Where
\eqn{\varepsilon} represents a statistic of interest,
the subindex \eqn{0} indicates an estimate using the total weights,
\eqn{r} indicates a replicate from a total of \eqn{R},
 \eqn{p} indicates a plausible value from a total of \eqn{P},
 and \eqn{c} indicates an element in a composite estimate from value a total of \eqn{C}.
}
\examples{
# Creation of replicate weights
RW <- repcreate(df = repdata, # the data frame with all the information
                wt = "wt", # the total weights column name
                jkzone = "jkzones", # the jkzones column name
                jkrep = "jkrep", # the jkreps column name
                repwtname = "REPWT", # the desired name for the rep weights
                reps = 50, # the number of replications
                method = "ICILS") # the name of the method aka the study name

# Non-PVs ----

## Mean with total weights
E0 <- stats::weighted.mean(x = repdata$item01, w = repdata$wt, na.rm = TRUE)
E0

## Means by replication
ER <- as.vector(apply(RW,2,function(i){
  stats::weighted.mean(x = repdata$item01, w = i, na.rm = TRUE)
}))
ER

## Standard error by hand
repse(er = ER, e0 = E0, method = "ICILS")

## Standard error with repmean()
repmean(x = "item01",wt = "wt",repwt = RW,df = repdata, method = "ICILS")


# PVs ----

## Mean with total weights
E0 <- sapply(1:5,function(i){
  stats::weighted.mean(x = repdata[,paste0("Math",i)], w = repdata$wt,
                       na.rm = TRUE)
})
E0

## Means by replication
ER <- lapply(1:5, function(j){
  as.vector(apply(RW,2,function(i){
    stats::weighted.mean(x = repdata[,paste0("Math",j)], w = i, na.rm = TRUE)
  }))
})
ER

## Standard error by hand
repse(er = ER, e0 = E0, method = "ICILS")

## Standard error with repmean()
repmean(x = paste0("Math",1:5),wt = "wt",repwt = RW,df = repdata, method = "ICILS",PV = TRUE)


}
