% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rff_random.R
\name{rff_random}
\alias{rff_random}
\title{Generate random Fourier features parameters}
\usage{
rff_random(m, d = d, rho = 1, kernel = "gaussian")
}
\arguments{
\item{m}{Number of random features \eqn{m} used in the RFF
approximation. If not specified, the recommended choice is
\deqn{\left\lceil n \cdot \frac{\log(d + 5)}{10} \right\rceil}
where \eqn{X} is design matrix, \eqn{n = nrow(X)} and \eqn{d = ncol(X)}.}

\item{d}{Design matrix's dimension (\eqn{d = ncol(X)}).}

\item{rho}{Kernel width parameter (\eqn{\rho}), specified by the user.
Controls the scale of the kernel function. Defaults to \code{1}.}

\item{kernel}{Kernel matrix \eqn{K \in \mathbb{R}^{n \times n}} has two kinds of Kernel ("gaussian", "laplace").}
}
\value{
A list with components:
\describe{
  \item{w}{Random frequency matrix \eqn{\omega \in \mathbb{R}^{d \times m}},
    sampled i.i.d. from a Cauchy distribution.}
  \item{b}{Random phase vector \eqn{b \in \mathbb{R}^m}, i.i.d. \eqn{\mathrm{Unif} [ 0,\,2\pi ]}.}
}
}
\description{
This function generates random frequency matrix \eqn{\omega} and offsets
random phase vector \eqn{b}
used in the Random Fourier Features (RFF) method.
}
\details{
\strong{Notation.} Let \eqn{X \in \mathbb{R}^{n \times d}} denote the design matrix
of inputs on which RFF will be applied downstream (with \eqn{n = nrow(X)},
\eqn{d = ncol(X)}). A commonly recommended choice for the number of random
features is
\deqn{\left\lceil n \cdot \frac{\log(d + 5)}{10} \right\rceil.}
}
\examples{
set.seed(1)
lambda = 1e-4
d = 1
rho = 1
n = 1000
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
m = ceiling(n* log(d + 5)/ 10)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))
rv = rff_random(m = m, d = d, rho = 1, kernel = "gaussian")
str(rv)

}
