# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Euclidean climatch scores
#'
#' Vector of the climatch scores within the recipient region
#'
#' @param recipient A data.frame of climatic variables for the recipient region.
#' @param source A data.frame of climatic variables for the source region.
#' @param globvar A vector of the global variance of each climate variable, in the same order as the columns of source and recipient region data.frames.
#'
#' @return A vector of climatch scores corresponding to each grid cell within recipient region, i.e., each row in the recipient data.frame.
#'
#' @usage climatch_vec(recipient, source, globvar)
#'
#' @export
#' @references Crombie, J., Brown, L., Lizzio, J., & Hood, G. (2008). "Climatch user manual"
#'
#' @examples
#' i <- as.data.frame(matrix(runif(n=180, min=1, max=20), nrow=60)) # Fake source climate data
#' j <- as.data.frame(matrix(runif(n=300, min=10, max=40), nrow=100)) # Fake recipient data
#' variance <- c(600, 800, 450) # Fake global variance
#'
#' climatch_vec(recipient = j, source = i, globvar = variance)
#'
climatch_vec <- function(recipient, source, globvar) {
    .Call(`_Euclimatch_climatch_vec`, recipient, source, globvar)
}

