% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinkFunc.R
\name{log_link}
\alias{log_link}
\title{Logarithmic link function (for estimation with \code{maxlogL} object)}
\usage{
log_link()
}
\value{
A list with logit link function, its inverse and its name.
}
\description{
\code{log_link} object provides a way to implement logarithmic link function that
\code{\link{maxlogL}} needs to perform estimation. See documentation for
\code{\link{maxlogL}} for further information on parameter estimation and implementation
of link objects.
}
\details{
\code{log_link} is part of a family of generic functions with no input arguments that
defines and returns a list with details of the link function:
\enumerate{
\item \code{name}: a character string with the name of the link function.
\item \code{g}: implementation of the link function as a generic function in \code{R}.
\item \code{g_inv}: implementation of the inverse link function as a generic function
in \code{R}.
}

There is a way to add new mapping functions. The user must specify the details aforesaid.
}
\examples{
# One parameters of normal distribution mapped with logarithmic function
x <- rnorm(n = 10000, mean = 50, sd = 4)
theta_2 <- maxlogL( x = x, link = list(over = "sd",
                                       fun = "log_link") )
summary(theta_2)

# Link function name
fun <- log_link()$name
print(fun)

# Link function
g <- log_link()$g
curve(g(x), from = 0, to = 1)

# Inverse link function
ginv <- log_link()$g_inv
curve(ginv(x), from = -5, to = 5)

}
\seealso{
\code{\link{maxlogL}}

Other link functions: 
\code{\link{NegInv_link}()},
\code{\link{logit_link}()}
}
\concept{link functions}
