% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allMethods.R
\name{estimateIGTProjection}
\alias{estimateIGTProjection}
\alias{estimateIGTProjection,IGTProjection-method}
\alias{estimateIGTProjection,DataTemporalMap-method}
\title{Estimates an Information Geometric Temporal plot projection}
\usage{
estimateIGTProjection(
  dataTemporalMap,
  dimensions = 3,
  startDate = NULL,
  endDate = NULL,
  embeddingType = "classicalmds"
)

\S4method{estimateIGTProjection}{DataTemporalMap}(
  dataTemporalMap,
  dimensions = 3,
  startDate = NULL,
  endDate = NULL,
  embeddingType = "classicalmds"
)
}
\arguments{
\item{dataTemporalMap}{of class \code{DataTemporalMap} object.}

\item{dimensions}{\code{numeric} integer value indicating the number of dimensions 
for the projection.}

\item{startDate}{a Date object indicating the date at which to start the analysis, 
in case of being different from the first chronological date in the date column 
(the default).}

\item{endDate}{a Date object indicating the date at which to end the analysis, 
in case of being different from the last chronological date in the date column 
(the default).}

\item{embeddingType}{the type of embedding to apply to the dissimilarity matrix of time batches
in order to obtain the non-parametric Statistical Manifold, from "classicalmds" and "nonmetricmds", 
with "classicalmds" as default. "classicalmds" uses the base R stats::cmdscale function, while "nonmetricmds"
uses the MASS:isoMDS function. The returned stress format will depend on the selected embedding type:
"classicalmds" returns 1-GOF as returned by stats::cmdscale function, "nonmetricmds" returns the final stress
in percent, as returned by the MASS::isoMDS function}
}
\value{
An \code{IGTProjection} object containing the projected coordinates of each
temporal batch in the embedded non-parametric Statistical Manifold, as well as the
embedding stress according to the embeddingType.
}
\description{
Estimates an \code{IGTProjection} object from a \code{DataTemporalMap} object.
}
\examples{
load(system.file("extdata",
                 "variabilityDemoNHDSdiagcode1-phewascode.RData",
                  package="EHRtemporalVariability"))
igtProj <- estimateIGTProjection( dataTemporalMap = probMaps$`diagcode1-phewascode`, 
dimensions      = 3, 
startDate       = "2000-01-01", 
endDate         = "2010-12-31")

\dontrun{

# For additional and larger examples download the following .Rdata file:

gitHubUrl  <- 'http://github.com/'
gitHubPath <- 'hms-dbmi/EHRtemporalVariability-DataExamples/'
gitHubFile <- 'raw/master/variabilityDemoNHDS.RData'
inputFile  <-  paste0(gitHubUrl, gitHubPath, gitHubFile)

load(url(inputFile))
igtProj <- estimateIGTProjection( dataTemporalMap = probMaps[[1]], 
dimensions      = 3, 
startDate       = "2000-01-01", 
endDate         = "2010-12-31")
}
}
