\name{rosenbrock}
\alias{rosenbrock}
\title{Rosenbrock function for optimization problems}

\usage{
rosenbrock(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Rosenbrock function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Rosenbrock function at the input vector \code{x}.
}

\description{
The Rosenbrock function, also known as the "Rosenbrock's valley" or "banana function", is a non-convex function commonly used as a performance test for optimization algorithms. It features a narrow, curved valley that contains the global minimum, which makes it particularly challenging for optimization methods. The global minimum is located at the point where all variables are equal to 1.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(1, 4)
rosenbrock(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
rosenbrock(x)

# Contour Plot: Visualizing the Rosenbrock Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) rosenbrock(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Rosenbrock Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = rosenbrock, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) rosenbrock(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Rosenbrock Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
Rosenbrock, H. H. (1960). \emph{An Automatic Method for Finding the Greatest or Least Value of a Function}. The Computer Journal, 3(3), 175–184. \doi{10.1093/comjnl/3.3.175}
}
