% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gg_LL}
\alias{gg_LL}
\title{Gamma-Gamma: Log-Likelihood Function}
\usage{
gg_LL(vLogparams, vX, vM_x)
}
\arguments{
\item{vLogparams}{a vector containing the log of the parameters p, q, gamma}

\item{vX}{frequency vector of length n counting the numbers of purchases}

\item{vM_x}{the observed average spending for every customer during the calibration time.}
}
\value{
Returns the Log-Likelihood value for the Gamma-Gamma model.
}
\description{
Calculates the Log-Likelihood value for the Gamma-Gamma model.
}
\details{
\code{vLogparams} is a vector with the parameters for the Gamma-Gamma model.
It has three parameters (p, q, gamma). The scale parameter for each transaction
is distributed across customers according to a gamma distribution with
parameters q (shape) and gamma (scale).
}
\references{
Colombo R, Jiang W (1999). \dQuote{A stochastic RFM model.}
Journal of Interactive Marketing, 13(3), 2–12.

Fader PS, Hardie BG, Lee K (2005). \dQuote{RFM and CLV: Using Iso-Value Curves for
Customer Base Analysis.} Journal of Marketing Research, 42(4), 415–430.

Fader PS, Hardie BG (2013). \dQuote{The Gamma-Gamma Model of Monetary Value.}
URL \url{http://www.brucehardie.com/notes/025/gamma_gamma.pdf}.
}
