% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_SFM_skew_normal.R
\name{gibbs_SFM_skew_n}
\alias{gibbs_SFM_skew_n}
\title{Bayesian estimation of a mixture of Skew Normal distributions.}
\usage{
gibbs_SFM_skew_n(y, K, nb_iter, priors = list(), printing = TRUE)
}
\arguments{
\item{y}{Vector of observations.}

\item{K}{Maximum number of mixture components.}

\item{nb_iter}{Number of MCMC iterations.}

\item{priors}{List of priors. Default is :
list(a0 = 1, A0 = 200, b0 = median(y), D_xi = 1, D_psi = 1, # where (B0 = diag(D_xi, D_psi)), c0 = 2.5, g0 = 0.5, G0 = g0/(0.5*var(y)))}

\item{printing}{Print intermediate output of the MCMC estimation ? default = TRUE.}
}
\value{
mcmc_draws : Parameter draws from the posterior distribution at each MCMC iteration. A (nb_iter x 4K + 1) matrix.
}
\description{
MCMC estimation using a sparse finite mixture (SFM) algorithm.
}
\references{
\insertRef{malsiner-walli_model-based_2016}{BayesMultiMode}\cr\cr
\insertRef{malsiner-walli_model-based_2016}{BayesMultiMode}\cr\cr
\insertRef{fruhwirth-schnatter_bayesian_2010}{BayesMultiMode}\cr\cr
\insertRef{SFS:Mal:2019}{BayesMultiMode} \cr\cr
\insertRef{azzalini_1985}{BayesMultiMode}
}
\keyword{internal}
