% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corranalysis.R
\name{corranalysis}
\alias{corranalysis}
\title{Correlation analysis}
\usage{
corranalysis(data, threshold = 0, sig.level = 0.95)
}
\arguments{
\item{data}{a numeric matrix or data frame (see \code{\link[stats]{cor}}).}

\item{threshold}{numeric, correlation cutoff (default 0); correlations in absolute value below \code{threshold} are set to 0.}

\item{sig.level}{numeric, significance level (default 0.95); correlations with p-values greater that \code{1-sig.level} are set to 0.}
}
\value{
A list with the following elements:
\itemize{
\item \code{corr.mtx} (the complete correlation matrix)
\item \code{corr.mtx.trunc} (the truncated correlation matrix)
\item \code{cor.mtest} (the output of the significance test on correlations; see \code{\link[corrplot]{cor.mtest}})
\item \code{threshold} correlation cutoff
\item \code{sig.level} significance level
}
}
\description{
Correlation analysis
}
\examples{
data <- data.frame(Pbox$PTS,Pbox$P3M,Pbox$P2M,
                   Pbox$OREB + Pbox$DREB,Pbox$AST,
                   Pbox$TOV,Pbox$STL,Pbox$BLK)/Pbox$MIN
names(data) <- c("PTS","P3M","P2M","REB","AST","TOV","STL","BLK")
data <- subset(data, Pbox$MIN >= 500)
out <- corranalysis(data, threshold = 0.5)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{plot.corranalysis}}.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
