% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grubbs_outliers.R
\name{grubbs_outliers}
\alias{grubbs_outliers}
\title{Outlier Detection Using Grubbs' Test (Iterative)}
\usage{
grubbs_outliers(dataSet, vD, alpha = 0.05)
}
\arguments{
\item{dataSet}{A \code{data.frame} containing the data.}

\item{vD}{Unquoted name of the numeric variable to be tested for outliers.}

\item{alpha}{Significance level for the test (default is \code{0.05}).}
}
\value{
A \code{data.frame} identical to the input, with an added logical column \code{outL}
indicating which observations were identified as outliers (\code{TRUE} or \code{FALSE}).
}
\description{
Detects one or more outliers in a numeric variable using the iterative Grubbs' test,
which assumes the data follow a normal distribution.
}
\details{
The function applies Grubbs' test iteratively, removing the most extreme value
and retesting until no further significant outliers are found.
The test is valid only under the assumption of normality.
}
\examples{
data(d_e, package = "Analitica")
d<-grubbs_outliers(d_e, Sueldo_actual)
}
\references{
Grubbs, F. E. (1969). "Procedures for Detecting Outlying Observations in Samples."
\emph{Technometrics}, 11(1), 1–21. \doi{10.1080/00401706.1969.10490657}
}
