% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Time_aggregate.R
\name{Time_aggregate}
\alias{Time_aggregate}
\title{Aggregate ARPALdf data to hourly, daily, weekly and mothly aggregations}
\usage{
Time_aggregate(Dataset, Frequency, Var_vec = NULL, Fns_vec = NULL, verbose = T)
}
\arguments{
\item{Dataset}{ARPALdf dataframe to aggregate.}

\item{Frequency}{Temporal aggregation frequency. It can be "hourly", "daily", "weekly",
"monthly" or "yearly.}

\item{Var_vec}{Vector of variables to aggregate. If NULL (default) all the variables are averaged,
expect for 'Temperature' and 'Snow_height' which are summed.}

\item{Fns_vec}{Vector of aggregation function to apply to the selected variables. Available functions
are mean, median, min, max, sum and qXX for the XX_th percentile.}

\item{verbose}{Logic value (T or F). Toggle warnings and messages. If 'verbose=T' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose=F' any message about
the progression is suppressed.}
}
\value{
A data frame
}
\description{
'Time_aggregate' returns an ARPALdf object aggregating observations by hourly,
daily, weekly and mothly periods. The function can be applied only to ARPALdf objects.
User can indicate specific variables to aggregate and an aggregation function (mean,sum,min,max)
for each variable.It is possible to specify different aggregation functions on the same variable
by repeating the name of the variable in Var_vec and specifying the functions in Fns_vec.
}
\examples{
\donttest{
## Download hourly observed concentrations from all the stations in the network during 2019.
data <- get_ARPA_Lombardia_AQ_data(ID_station=NULL,Year=2020,Frequency="hourly")
## Aggregate all the data to daily frequency
Time_aggregate(Dataset=data,Frequency="daily",Var_vec=NULL,Fns_vec=NULL)
## Aggregate NO2 to weekly maximum concentrations and NOx to weekly minimum concentrations.
Time_aggregate(Dataset=data,Frequency="weekly",Var_vec=c("NO2","NOx"),Fns_vec=c("max","min"))
}

}
