/*
 * Decompiled with CFR 0.152.
 */
package partition;

import partition.Cell;
import partition.EastingNorthing;
import partition.LatLong;
import partition.Location;

public class Cluster {
    private int _id;
    private Location _center;
    private int _numberOfCells = 0;
    private boolean _isFixed = false;
    private double _sumS1 = 0.0;
    private double _sumS2 = 0.0;
    private double _sumS3 = 0.0;
    private boolean _isActivePrevious = false;
    private boolean _isActiveCurrent = true;

    public Cluster(int id, Location center, boolean isFixed) {
        this._id = id;
        this.setCenter(center, isFixed);
    }

    public final boolean isFixed() {
        return this._isFixed;
    }

    public final void activate() {
        this._isActivePrevious = this._isActiveCurrent;
        this._isActiveCurrent = true;
    }

    public final void deactivate() {
        this._isActivePrevious = this._isActiveCurrent;
        this._isActiveCurrent = false;
    }

    public final boolean isActive() {
        return this._isActivePrevious | this._isActiveCurrent;
    }

    public final void add(Cell cell) {
        cell.setCluster(this);
        Location center = cell.getCenter();
        this._sumS1 += center._s1;
        this._sumS2 += center._s2;
        this._sumS3 += center._s3;
        ++this._numberOfCells;
    }

    public final void remove(Cell cell) {
        cell.setCluster(null);
        Location center = cell.getCenter();
        this._sumS1 -= center._s1;
        this._sumS2 -= center._s2;
        this._sumS3 -= center._s3;
        --this._numberOfCells;
    }

    public final int getId() {
        return this._id;
    }

    public final void setId(int id) {
        this._id = id;
    }

    public final Location getCenter() {
        if (!this.isFixed() & this._numberOfCells > 0) {
            this._center = this._center instanceof LatLong ? new LatLong(Math.toDegrees(Math.atan2(this._sumS2, this._sumS1)), Math.toDegrees(Math.asin(this._sumS3 / (double)this._numberOfCells))) : new EastingNorthing(this._sumS1 / (double)this._numberOfCells, this._sumS2 / (double)this._numberOfCells);
        }
        return this._center;
    }

    public final void setCenter(Location center, boolean isFixed) {
        this._center = center;
        this._isFixed = isFixed;
    }

    public final void setCenter(Location center) {
        this.setCenter(center, true);
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getId() + "]";
    }
}

