## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(PenguinR)
library(ggplot2)
library(dplyr)

## ----peng-subcortical-plot, fig.width=6, fig.height=4, out.width="100%"-------

# Prepare summary or filtered data (optional)
peng_summary <- peng_df %>%
  filter(!is.na(flipper_length), !is.na(body_mass)) %>%
  group_by(species, sex) %>%
  summarise(
    mean_flipper = mean(flipper_length, na.rm = TRUE),
    mean_mass = mean(body_mass, na.rm = TRUE),
    .groups = "drop"
  )

# Scatterplot: Body mass vs Flipper length by species and sex
ggplot(peng_df, aes(x = flipper_length, y = body_mass, color = species, shape = sex)) +
  geom_point(size = 2, alpha = 0.8) +
  geom_smooth(method = "lm", se = FALSE, linetype = "dashed", color = "black") +
  labs(
    title = "Body Mass vs Flipper Length in Penguins",
    subtitle = "Data by Species and Sex near Palmer Station, Antarctica",
    x = "Flipper Length (mm)",
    y = "Body Mass (g)",
    color = "Species",
    shape = "Sex"
  ) +
  theme_minimal() +
  theme(
    plot.title = element_text(face = "bold"),
    axis.text.x = element_text(angle = 45, hjust = 1)
  )



