/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.model.ReciprocalLikelihood;
import dr.inference.model.TransformedParameter;
import dr.util.Transform;
import dr.xml.Reportable;

public class TransformedGradientWrtParameter
implements GradientWrtParameterProvider,
Reportable {
    private final GradientWrtParameterProvider gradient;
    private final TransformedParameter parameter;
    private final ReciprocalLikelihood reciprocalLikelihood;
    private final boolean includeJacobian;
    private final boolean inverse;

    public TransformedGradientWrtParameter(GradientWrtParameterProvider gradientWrtParameterProvider, TransformedParameter transformedParameter, ReciprocalLikelihood reciprocalLikelihood, boolean bl, boolean bl2) {
        this.gradient = gradientWrtParameterProvider;
        this.parameter = transformedParameter;
        this.reciprocalLikelihood = reciprocalLikelihood;
        this.includeJacobian = bl;
        this.inverse = bl2;
    }

    @Override
    public Likelihood getLikelihood() {
        if (this.reciprocalLikelihood != null) {
            return this.reciprocalLikelihood;
        }
        return this.gradient.getLikelihood();
    }

    @Override
    public Parameter getParameter() {
        return this.parameter.getUntransformedParameter();
    }

    @Override
    public int getDimension() {
        return this.parameter.getUntransformedParameter().getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray;
        Object object;
        double[] dArray2 = this.gradient.getGradientLogDensity();
        double[] dArray3 = this.parameter.getParameterUntransformedValues();
        Transform transform = this.parameter.getTransform();
        if (this.inverse) {
            transform = transform.inverseTransform();
        }
        if (transform instanceof Transform.MultivariableTransform) {
            object = (Transform.MultivariableTransform)transform;
            dArray = object.updateGradientLogDensity(dArray2, dArray3, 0, dArray3.length);
            if (!this.includeJacobian) {
                throw new RuntimeException("Not yet implemented");
            }
        } else {
            int n;
            object = this.parameter.getParameterValues();
            dArray = new double[dArray2.length];
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = transform.updateGradientLogDensity(dArray2[n], (double)object[n]);
            }
            if (!this.includeJacobian) {
                for (n = 0; n < dArray.length; ++n) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] - transform.gradientLogJacobianInverse(this.parameter.getParameterValue(n));
                }
            }
        }
        if (this.reciprocalLikelihood != null) {
            int n = 0;
            while (n < dArray.length) {
                int n3 = n++;
                dArray[n3] = dArray[n3] * -1.0;
            }
        }
        return dArray;
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null);
    }
}

