/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.SpaceTimeRejector;
import dr.math.distributions.MultivariateNormalDistribution;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class NumericalSpaceTimeProbs2D {
    final int latticeWidth;
    final int latticeHeight;
    final int tsteps;
    final int subtsteps;
    final double minx;
    final double miny;
    final double dx;
    final double dy;
    final double dt;
    final MultivariateNormalDistribution D;
    final SpaceTimeRejector rejector;
    int[][][][][] counts;
    int[][][] normalization;
    int[][][] maxCount;

    public NumericalSpaceTimeProbs2D(int n, int n2, int n3, int n4, double d, Rectangle2D rectangle2D, MultivariateNormalDistribution multivariateNormalDistribution, SpaceTimeRejector spaceTimeRejector) {
        this.latticeWidth = n;
        this.latticeHeight = n2;
        this.tsteps = n3;
        this.subtsteps = n4;
        this.D = multivariateNormalDistribution;
        this.rejector = spaceTimeRejector;
        this.dt = d;
        this.minx = rectangle2D.getMinX();
        this.miny = rectangle2D.getMinY();
        this.dx = (rectangle2D.getMaxX() - this.minx) / (double)n;
        this.dy = (rectangle2D.getMaxY() - this.miny) / (double)n2;
        this.counts = new int[n][n2][n][n2][n3];
        this.normalization = new int[n][n2][n3];
        this.maxCount = new int[n][n2][n3];
    }

    public void populate(Point2D point2D, int n, boolean bl) {
        this.populate(this.x(point2D.getX()), this.y(point2D.getY()), n, bl);
    }

    public int populateAbsorbing(Point2D point2D, int n) {
        return this.populateAbsorbing(this.x(point2D.getX()), this.y(point2D.getY()), n);
    }

    public int populateAbsorbing(int n, int n2, int n3) {
        double d = this.dt / (double)this.subtsteps;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        int[] nArray = new int[this.tsteps];
        int[] nArray2 = new int[this.tsteps];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            double d2 = 0.0;
            dArray2[0] = ((double)n + Math.random()) * this.dx + this.minx;
            dArray2[1] = ((double)n2 + Math.random()) * this.dy + this.miny;
            while (this.rejector.reject(0.0, dArray2)) {
                dArray2[0] = ((double)n + Math.random()) * this.dx + this.minx;
                dArray2[1] = ((double)n2 + Math.random()) * this.dy + this.miny;
            }
            boolean bl = false;
            for (int j = 0; j < this.tsteps && !bl; ++j) {
                for (int k = 0; k < this.subtsteps && !bl; ++k) {
                    this.D.nextScaledMultivariateNormal(dArray2, d, dArray);
                    bl = this.rejector.reject(d2 += d, dArray);
                    if (bl) continue;
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                }
                if (bl) continue;
                nArray[j] = this.x(dArray[0]);
                nArray2[j] = this.y(dArray[1]);
                this.increment(n, n2, nArray[j], nArray2[j], j);
            }
            if (!bl) {
                ++n4;
            }
            if (i % 10000 != 0) continue;
            System.out.print(".");
            System.out.flush();
        }
        System.out.println();
        return n4;
    }

    public void populate(int n, int n2, int n3, boolean bl) {
        double d = this.dt / (double)this.subtsteps;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        int[] nArray = new int[this.tsteps];
        int[] nArray2 = new int[this.tsteps];
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            double d2 = 0.0;
            dArray2[0] = ((double)n + Math.random()) * this.dx + this.minx;
            dArray2[1] = ((double)n2 + Math.random()) * this.dy + this.miny;
            while (this.rejector.reject(0.0, dArray2)) {
                dArray2[0] = ((double)n + Math.random()) * this.dx + this.minx;
                dArray2[1] = ((double)n2 + Math.random()) * this.dy + this.miny;
            }
            for (n5 = 0; n5 < this.tsteps; ++n5) {
                for (n4 = 0; n4 < this.subtsteps; ++n4) {
                    do {
                        this.D.nextScaledMultivariateNormal(dArray2, d, dArray);
                    } while (this.rejector.reject(d2 += d, dArray));
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                }
                nArray[n5] = this.x(dArray[0]);
                nArray2[n5] = this.y(dArray[1]);
                this.increment(n, n2, nArray[n5], nArray2[n5], n5);
            }
            if (bl) {
                for (n5 = 0; n5 < this.tsteps; ++n5) {
                    for (n4 = n5 + 1; n4 < this.tsteps; ++n4) {
                        this.increment(nArray[n5], nArray2[n5], nArray[n4], nArray2[n4], n4 - n5 - 1);
                    }
                }
            }
            if (i % 1000 != 0) continue;
            System.out.print(".");
            System.out.flush();
        }
    }

    private void increment(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = this.counts[n][n2][n3][n4];
        int n6 = n5;
        nArray[n6] = nArray[n6] + 1;
        int[] nArray2 = this.normalization[n][n2];
        int n7 = n5;
        nArray2[n7] = nArray2[n7] + 1;
        if (this.counts[n][n2][n3][n4][n5] > this.maxCount[n][n2][n5]) {
            this.maxCount[n][n2][n5] = this.counts[n][n2][n3][n4][n5];
        }
    }

    public void populate(int n) {
        System.out.println("Populating numerical transition probabilities");
        for (int i = 0; i < this.latticeWidth; ++i) {
            for (int j = 0; j < this.latticeHeight; ++j) {
                this.populate(i, j, n, true);
            }
            System.out.print(".");
            System.out.flush();
        }
        System.out.println(this.latticeWidth * this.latticeHeight * n + " new paths computed.");
    }

    public final int x(double d) {
        return (int)((d - this.minx) / this.dx);
    }

    public final int y(double d) {
        return (int)((d - this.miny) / this.dy);
    }

    public final int t(double d) {
        return (int)(d / this.dt);
    }

    public double getProb(Point2D point2D, Point2D point2D2, double d) {
        int n = this.x(point2D.getX());
        int n2 = this.x(point2D.getY());
        int n3 = this.x(point2D2.getX());
        int n4 = this.x(point2D2.getY());
        if (d > (double)this.tsteps * this.dt) {
            System.err.println("Time = " + d + ", max time estimated is " + (double)this.tsteps * this.dt);
            return (double)this.counts[n][n2][n3][n4][this.tsteps - 1] / (double)this.normalization[n][n2][this.tsteps - 1];
        }
        int n5 = this.t(d);
        double d2 = (double)n5 * this.dt;
        double d3 = d2 + this.dt;
        double d4 = (d3 - d) / this.dt;
        return d4 * this.p(n, n2, n3, n4, n5) + (1.0 - d4) * this.p(n, n2, n3, n4, n5 + 1);
    }

    public double p(int n, int n2, int n3, int n4, int n5) {
        return (double)this.counts[n][n2][n3][n4][n5] / (double)this.normalization[n][n2][n5];
    }

    public double r(int n, int n2, int n3, int n4, int n5) {
        return (double)this.counts[n][n2][n3][n4][n5] / (double)this.maxCount[n][n2][n5];
    }

    public void writeToFile(String string) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(string);
        printWriter.write("xsteps=" + this.latticeWidth + "\n");
        printWriter.write("ysteps=" + this.latticeHeight + "\n");
        printWriter.write("tsteps=" + this.tsteps + "\n");
        printWriter.write("dx=" + this.dx + "\n");
        printWriter.write("dy=" + this.dy + "\n");
        printWriter.write("dt=" + this.dt + "\n");
        printWriter.write("minx=" + this.minx + "\n");
        printWriter.write("miny=" + this.miny + "\n");
        printWriter.write("D=" + this.matrixString());
        for (int i = 0; i < this.latticeWidth; ++i) {
            for (int j = 0; j < this.latticeHeight; ++j) {
                for (int k = 0; k < this.latticeWidth; ++k) {
                    for (int i2 = 0; i2 < this.latticeHeight; ++i2) {
                        for (int i3 = 0; i3 < this.tsteps; ++i3) {
                            printWriter.write(i + "\t" + j + "\t" + k + "\t" + i2 + "\t" + i3 + "\t" + this.counts[i][j][k][i2][i3] + "\n");
                        }
                    }
                }
            }
        }
        printWriter.close();
    }

    private String matrixString() {
        double[][] dArray = this.D.getScaleMatrix();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append("[");
            stringBuilder.append(dArray[i][0]);
            for (int j = 1; j < dArray[i].length; ++j) {
                stringBuilder.append("," + dArray[i][0]);
            }
            stringBuilder.append("]");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        MultivariateNormalDistribution multivariateNormalDistribution = new MultivariateNormalDistribution(new double[]{0.0}, new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        NumericalSpaceTimeProbs2D numericalSpaceTimeProbs2D = new NumericalSpaceTimeProbs2D(50, 50, 50, 1, 0.02, double_, multivariateNormalDistribution, SpaceTimeRejector.Utils.createSimpleBounds2D(double_));
        long l = System.currentTimeMillis();
        numericalSpaceTimeProbs2D.populate(0, 0, 1000, true);
        long l2 = System.currentTimeMillis();
        System.out.println("Time taken = " + (l2 - l) / 1000L + " seconds");
        for (int i = 0; i < 10; ++i) {
            Point2D.Double double_2 = new Point2D.Double(Math.random(), Math.random());
            Point2D.Double double_3 = new Point2D.Double(Math.random(), Math.random());
            double d = Math.random();
            double d2 = numericalSpaceTimeProbs2D.getProb(double_2, double_3, d);
            System.out.println("Pr(" + ((Point2D)double_3).getX() + ", " + ((Point2D)double_3).getY() + " | " + ((Point2D)double_2).getX() + ", " + ((Point2D)double_2).getY() + ", t=" + d + ") = " + d2);
        }
    }
}

