/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeDoubleTraitProvider;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.branchratemodel.NodeRateMap;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.function.DoubleBinaryOperator;

public class TreeParameterModel
extends AbstractModel
implements TreeTrait<Double>,
TreeDoubleTraitProvider {
    protected final MutableTreeModel tree;
    private final Parameter parameter;
    private final Parameter rootNodeNumber;
    private boolean includeRoot;
    private TreeTrait.Intent intent;
    private boolean inHandleRootMove = false;

    public TreeParameterModel(MutableTreeModel mutableTreeModel, Parameter parameter, boolean bl) {
        this(mutableTreeModel, parameter, bl, TreeTrait.Intent.NODE);
    }

    public TreeParameterModel(MutableTreeModel mutableTreeModel, Parameter parameter, Type type) {
        this(mutableTreeModel, parameter, type == Type.WITH_ROOT, TreeTrait.Intent.NODE);
    }

    public TreeParameterModel(MutableTreeModel mutableTreeModel, Parameter parameter, boolean bl, TreeTrait.Intent intent) {
        super("treeParameterModel");
        this.tree = mutableTreeModel;
        this.parameter = parameter;
        this.includeRoot = bl;
        this.intent = intent;
        int n = parameter.getDimension();
        int n2 = this.getParameterSize();
        if (n != n2) {
            parameter.setDimension(n2);
        }
        this.addModel(mutableTreeModel);
        this.addVariable(parameter);
        this.rootNodeNumber = new Parameter.Default(parameter.getId() + ".rootNodeNumber");
        this.rootNodeNumber.setParameterValue(0, mutableTreeModel.getRoot().getNumber());
        this.addVariable(this.rootNodeNumber);
    }

    public int getParameterSize() {
        int n = this.tree.getNodeCount();
        if (!this.includeRoot) {
            --n;
        }
        return n;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree && !this.inHandleRootMove) {
            this.inHandleRootMove = true;
            this.handleRootMove();
            this.inHandleRootMove = false;
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (n == -1) {
            this.fireModelChanged(variable, n);
        } else {
            int n2 = this.getNodeNumberFromParameterIndex(n);
            assert (this.tree.getNode(n2).getNumber() == n2);
            this.fireModelChanged(variable, n2);
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getNodeDoubleValue(Tree tree, NodeRef nodeRef) {
        return this.getNodeValue(tree, nodeRef);
    }

    public double getNodeValue(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef) || this.includeRoot) : "root node doesn't have a parameter value!";
        assert (!this.includeRoot || tree.getRoot().getNumber() == ((Double)this.rootNodeNumber.getValue(0)).intValue()) : "INTERNAL ERROR! node with number " + this.rootNodeNumber + " should be the root node.";
        int n = nodeRef.getNumber();
        int n2 = this.getParameterIndexFromNodeNumber(n);
        return this.parameter.getParameterValue(n2);
    }

    public void setNodeValue(Tree tree, NodeRef nodeRef, double d) {
        assert (!tree.isRoot(nodeRef) && !this.includeRoot) : "root node doesn't have a parameter value!";
        assert (!this.includeRoot || tree.getRoot().getNumber() == ((Double)this.rootNodeNumber.getValue(0)).intValue()) : "INTERNAL ERROR! node with number " + this.rootNodeNumber + " should be the root node.";
        int n = nodeRef.getNumber();
        int n2 = this.getParameterIndexFromNodeNumber(n);
        this.parameter.setParameterValue(n2, d);
    }

    public int getNodeNumberFromParameterIndex(int n) {
        if (!this.includeRoot && n >= this.tree.getRoot().getNumber()) {
            return n + 1;
        }
        return n;
    }

    public int getParameterIndexFromNodeNumber(int n) {
        if (!this.includeRoot && n > this.tree.getRoot().getNumber()) {
            return n - 1;
        }
        return n;
    }

    private void handleRootMove() {
        int n;
        int n2;
        if (!this.includeRoot && (n2 = ((Double)this.rootNodeNumber.getValue(0)).intValue()) != (n = this.tree.getRoot().getNumber())) {
            if (n2 > n) {
                double d = this.parameter.getParameterValue(n);
                int n3 = Math.min(this.parameter.getDimension() - 1, n2);
                for (int i = n; i < n3; ++i) {
                    this.parameter.setParameterValue(i, this.parameter.getParameterValue(i + 1));
                }
                this.parameter.setParameterValue(n3, d);
            } else if (n2 < n) {
                int n4 = Math.min(this.parameter.getDimension() - 1, n);
                double d = this.parameter.getParameterValue(n4);
                for (int i = n4; i > n2; --i) {
                    this.parameter.setParameterValue(i, this.parameter.getParameterValue(i - 1));
                }
                this.parameter.setParameterValue(n2, d);
            }
            this.rootNodeNumber.setParameterValue(0, n);
        }
    }

    public void forEach(NodeRateMap nodeRateMap) {
        NodeRef nodeRef;
        int n;
        int n2 = this.parameter.getDimension();
        int n3 = this.tree.getRoot().getNumber();
        for (n = 0; n < n2; ++n) {
            nodeRef = this.tree.getNode(n);
            assert (nodeRef.getNumber() == n);
            nodeRateMap.apply(n, nodeRef, this.parameter.getParameterValue(n));
        }
        if (n2 > n3) {
            for (n = n3; n < n2; ++n) {
                nodeRef = this.tree.getNode(n + 1);
                assert (nodeRef.getNumber() == n + 1);
                nodeRateMap.apply(n, nodeRef, this.parameter.getParameterValue(n));
            }
        }
    }

    public double mapReduce(NodeRateMap nodeRateMap, DoubleBinaryOperator doubleBinaryOperator, double d) {
        NodeRef nodeRef;
        int n;
        int n2 = this.parameter.getDimension();
        int n3 = this.tree.getRoot().getNumber();
        for (n = 0; n < n2; ++n) {
            nodeRef = this.tree.getNode(n);
            assert (nodeRef.getNumber() == n);
            d = doubleBinaryOperator.applyAsDouble(d, nodeRateMap.apply(n, nodeRef, this.parameter.getParameterValue(n)));
        }
        if (this.includeRoot && n2 > n3) {
            for (n = n3; n < n2; ++n) {
                nodeRef = this.tree.getNode(n + 1);
                assert (nodeRef.getNumber() == n + 1);
                d = doubleBinaryOperator.applyAsDouble(d, nodeRateMap.apply(n, nodeRef, this.parameter.getParameterValue(n)));
            }
        }
        return d;
    }

    public MutableTreeModel getTreeModel() {
        return this.tree;
    }

    public String[] getNodeAttributeLabel() {
        return new String[0];
    }

    public String[] getAttributeForNode(Tree tree, NodeRef nodeRef) {
        return new String[0];
    }

    @Override
    public String getTraitName() {
        return this.parameter.getId();
    }

    @Override
    public TreeTrait.Intent getIntent() {
        return this.intent;
    }

    @Override
    public Class getTraitClass() {
        return Double.class;
    }

    @Override
    public boolean getLoggable() {
        return true;
    }

    @Override
    public Double getTrait(Tree tree, NodeRef nodeRef) {
        return this.getNodeValue(tree, nodeRef);
    }

    @Override
    public String getTraitString(Tree tree, NodeRef nodeRef) {
        return Double.toString(this.getNodeValue(tree, nodeRef));
    }

    public static enum Type {
        WITHOUT_ROOT,
        WITH_ROOT;

    }
}

