/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import java.io.Serializable;
import java.util.List;

public class AttributesInformation
implements Serializable {
    protected Attribute[] attributes;
    protected int[] indexValues;
    protected int numberAttributes;
    protected Attribute defaultNumericAttribute;

    public AttributesInformation(AttributesInformation chunk) {
        this.attributes = (Attribute[])chunk.attributes.clone();
        this.indexValues = (int[])chunk.indexValues.clone();
        this.numberAttributes = chunk.numberAttributes;
    }

    public AttributesInformation(Attribute[] v, int[] i, int numberAttributes) {
        this.attributes = v;
        this.indexValues = i;
        this.numberAttributes = numberAttributes;
    }

    public AttributesInformation(Attribute[] v, int numberAttributes) {
        this.attributes = v;
        this.indexValues = new int[numberAttributes];
        for (int i = 0; i < numberAttributes; ++i) {
            this.indexValues[i] = i;
        }
        this.numberAttributes = numberAttributes;
    }

    public AttributesInformation(List<Attribute> v, int numberAttributes) {
        this.attributes = new Attribute[numberAttributes];
        this.indexValues = new int[numberAttributes];
        for (int i = 0; i < numberAttributes; ++i) {
            this.indexValues[i] = i;
            this.attributes[i] = v.get(i);
        }
        this.numberAttributes = numberAttributes;
    }

    public AttributesInformation() {
        this.attributes = null;
        this.indexValues = null;
        this.numberAttributes = 0;
        this.defaultNumericAttribute = null;
    }

    public Attribute attribute(int indexAttribute) {
        if (this.attributes == null) {
            return this.defaultNumericAttribute();
        }
        int location = this.locateIndex(indexAttribute);
        if (location == -1) {
            return this.defaultNumericAttribute();
        }
        return this.attributes[location];
    }

    public void setAttributes(Attribute[] v) {
        this.attributes = v;
        this.numberAttributes = v.length;
        this.indexValues = new int[this.numberAttributes];
        for (int i = 0; i < this.numberAttributes; ++i) {
            this.indexValues[i] = i;
        }
    }

    public int locateIndex(int index) {
        int min = 0;
        int max = this.indexValues.length - 1;
        if (max == -1) {
            return -1;
        }
        while (this.indexValues[min] <= index && this.indexValues[max] >= index) {
            int current = (max + min) / 2;
            if (this.indexValues[current] > index) {
                max = current - 1;
                continue;
            }
            if (this.indexValues[current] < index) {
                min = current + 1;
                continue;
            }
            return current;
        }
        if (this.indexValues[max] < index) {
            return max;
        }
        return min - 1;
    }

    private Attribute defaultNumericAttribute() {
        if (this.defaultNumericAttribute == null) {
            this.defaultNumericAttribute = new Attribute("default");
        }
        return this.defaultNumericAttribute;
    }

    public void setAttributes(Attribute[] v, int[] indexValues) {
        this.attributes = v;
        this.numberAttributes = v.length;
        this.indexValues = indexValues;
    }

    public void deleteAttributeAt(int position) {
        int index = this.locateIndex(position);
        --this.numberAttributes;
        if (index >= 0 && this.indexValues[index] == position) {
            int[] tempIndices = new int[this.indexValues.length - 1];
            Attribute[] tempValues = new Attribute[this.attributes.length - 1];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index);
            System.arraycopy(this.attributes, 0, tempValues, 0, index);
            for (int i = index; i < this.indexValues.length - 1; ++i) {
                tempIndices[i] = this.indexValues[i + 1] - 1;
                tempValues[i] = this.attributes[i + 1];
            }
            this.indexValues = tempIndices;
            this.attributes = tempValues;
        } else {
            int[] tempIndices = new int[this.indexValues.length];
            Attribute[] tempValues = new Attribute[this.attributes.length];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index + 1);
            System.arraycopy(this.attributes, 0, tempValues, 0, index + 1);
            for (int i = index + 1; i < this.indexValues.length; ++i) {
                tempIndices[i] = this.indexValues[i] - 1;
                tempValues[i] = this.attributes[i];
            }
            this.indexValues = tempIndices;
            this.attributes = tempValues;
        }
    }

    public void insertAttributeAt(Attribute attribute, int position) {
        if (position < 0 || position > this.numberAttributes) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        int index = this.locateIndex(position);
        ++this.numberAttributes;
        if (index >= 0 && this.indexValues[index] == position) {
            int[] tempIndices = new int[this.indexValues.length + 1];
            Attribute[] tempValues = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index);
            System.arraycopy(this.attributes, 0, tempValues, 0, index);
            tempIndices[index] = position;
            tempValues[index] = attribute;
            for (int i = index; i < this.indexValues.length; ++i) {
                tempIndices[i + 1] = this.indexValues[i] + 1;
                tempValues[i + 1] = this.attributes[i];
            }
            this.indexValues = tempIndices;
            this.attributes = tempValues;
        } else {
            int[] tempIndices = new int[this.indexValues.length + 1];
            Attribute[] tempValues = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index + 1);
            System.arraycopy(this.attributes, 0, tempValues, 0, index + 1);
            tempIndices[index + 1] = position;
            tempValues[index + 1] = attribute;
            for (int i = index + 1; i < this.indexValues.length; ++i) {
                tempIndices[i + 1] = this.indexValues[i] + 1;
                tempValues[i + 1] = this.attributes[i];
            }
            this.indexValues = tempIndices;
            this.attributes = tempValues;
        }
    }
}

