/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;

public class HouseholderWithPivoting {
    private static double EPS = 2.220446E-16;
    private int[] pivot_;
    private Matrix m_;
    private double[] norm_;
    private double[] rdiag_;

    public HouseholderWithPivoting(Matrix m) {
        this.m_ = m;
        this.qrDecomposition();
    }

    public double norm(int i) {
        return this.norm_[i];
    }

    public int[] getPivots() {
        return this.pivot_;
    }

    public IReadDataBlock getRDiag() {
        return new ReadDataBlock(this.rdiag_);
    }

    public void applyQty(double[] y) {
        int n = this.m_.getColumnsCount();
        int m = this.m_.getRowsCount();
        double[] a = this.m_.internalStorage();
    }

    private void qrDecomposition() {
        int n = this.m_.getColumnsCount();
        int m = this.m_.getRowsCount();
        double[] a = this.m_.internalStorage();
        double[] wa = new double[n];
        for (int k = 0; k < n; ++k) {
            double u;
            this.pivot_[k] = k;
            this.norm_[k] = u = this.m_.column(k).nrm2();
            this.rdiag_[k] = u;
            wa[k] = u;
        }
        int mn = Math.min(m, n);
        int j = 0;
        int jj = 0;
        int mj = m;
        while (j < mn) {
            double ajnorm;
            int kmax = j;
            for (int k = j + 1; k < n; ++k) {
                if (!(this.rdiag_[k] > this.rdiag_[kmax])) continue;
                kmax = k;
            }
            if (kmax != j) {
                this.m_.permuteColumns(j, kmax);
                this.rdiag_[kmax] = this.rdiag_[j];
                wa[kmax] = wa[j];
                int itmp = this.pivot_[j];
                this.pivot_[j] = this.pivot_[kmax];
                this.pivot_[kmax] = itmp;
            }
            if ((ajnorm = this.m_.column(j).drop(j, 0).nrm2()) > EPS) {
                if (a[jj] < 0.0) {
                    ajnorm = -ajnorm;
                }
                int ij = jj;
                while (ij < mj) {
                    int n2 = ij++;
                    a[n2] = a[n2] + ajnorm;
                }
                int n3 = jj;
                a[n3] = a[n3] + 1.0;
                int k = j + 1;
                int jk = jj + m;
                while (k < n) {
                    double sum = 0.0;
                    int ij2 = jj;
                    int ik = jk;
                    while (ij2 < mj) {
                        sum += a[ij2] * a[ik];
                        ++ij2;
                        ++ik;
                    }
                    double tmp = sum / a[jj];
                    int ik2 = jk;
                    for (int ij3 = jj; ij3 < mj; ++ij3) {
                        int n4 = ik2++;
                        a[n4] = a[n4] - tmp * a[ij3];
                    }
                    if (Math.abs(this.rdiag_[k]) > EPS) {
                        tmp = a[jk] / this.rdiag_[k];
                        int n5 = k;
                        this.rdiag_[n5] = this.rdiag_[n5] * Math.sqrt(Math.max(1.0 - tmp * tmp, 0.0));
                        tmp = this.rdiag_[k] / wa[k];
                        if (0.05 * tmp * tmp <= EPS) {
                            this.rdiag_[k] = this.m_.column(k).drop(j + 1, 0).nrm2();
                            wa[k] = this.rdiag_[k];
                        }
                    }
                    ++k;
                    jk += m;
                }
            }
            this.rdiag_[j] = -ajnorm;
            ++j;
            jj += m + 1;
            mj += m;
        }
    }
}

