## ----knitr-mechanics----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----pre-setup----------------------------------------------------------------
# devtools::install_github("njlyon0/supportR", force = TRUE)

## ----setup--------------------------------------------------------------------
#install.packages("supportR")
library(supportR)

## ----diff_check---------------------------------------------------------------
# Make two vectors
vec1 <- c("x", "a", "b")
vec2 <- c("y", "z", "a")

# Compare them!
supportR::diff_check(old = vec1, new = vec2, sort = TRUE, return = TRUE)

## ----num_check----------------------------------------------------------------
# Make a dataframe with non-numbers in a number column
fish <- data.frame("species" = c("salmon", "bass", "halibut", "eel"),
                   "count" = c(1, "14x", "_23", 12))

# Use `num_check` to identify non-numbers
supportR::num_check(data = fish, col = "count")

## ----date_check---------------------------------------------------------------
# Make a dataframe including malformed dates
sites <- data.frame("site" = c("LTR", "GIL", "PYN", "RIN"),
                    "visit" = c("2021-01-01", "2021-01-0w", "1990", "2020-10-xx"))

# Now we can use our function to identify bad dates
supportR::date_check(data = sites, col = "visit")

## ----date_format_guess--------------------------------------------------------
# Make a dataframe with dates in various formats and a grouping column
my_df <- data.frame("data_enterer" = c("person A", "person B",
                                       "person B", "person B",
                                       "person C", "person D",
                                       "person E", "person F",
                                       "person G"),
                    "bad_dates" = c("2022.13.08", "2021/2/02",
                                    "2021/2/03", "2021/2/04",
                                    "1899/1/15", "10-31-1901",
                                    "26/11/1901", "08.11.2004",
                                    "6/10/02"))

# Now we can invoke the function!
supportR::date_format_guess(data = my_df, date_col = "bad_dates",
                            group_col = "data_enterer", return = "dataframe")

# If preferred, do it without groups and return a vector
supportR::date_format_guess(data = my_df, date_col = "bad_dates",
                            groups = FALSE, return = "vector")

