/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.GeneralSubstitutionModel;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SVSGeneralSubstitutionModel
extends GeneralSubstitutionModel
implements Likelihood,
BayesianStochasticSearchVariableSelection,
Citable {
    private double[] probability = null;
    private boolean isUsed = false;
    private Parameter rateIndicator;

    public SVSGeneralSubstitutionModel(DataType dataType, FrequencyModel frequencyModel, Parameter parameter, Parameter parameter2) {
        super(dataType, frequencyModel, parameter, 1);
        if (parameter2 != null) {
            this.rateIndicator = parameter2;
            this.addVariable(this.rateIndicator);
        } else {
            this.rateIndicator = new Parameter.Default(parameter.getDimension(), 1.0);
        }
    }

    protected SVSGeneralSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, int n) {
        super(string, dataType, frequencyModel, n);
    }

    @Override
    public Parameter getIndicators() {
        return this.rateIndicator;
    }

    @Override
    public boolean validState() {
        return !this.updateMatrix || BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.ratesParameter && this.rateIndicator.getParameterValue(n) == 0.0) {
            return;
        }
        super.handleVariableChangedEvent(variable, n, changeType);
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (this.updateMatrix && !BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this)) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public boolean evaluateEarly() {
        return true;
    }

    @Override
    public void makeDirty() {
        this.updateMatrix = true;
    }

    @Override
    public String prettyName() {
        return "SVSGeneralSubstitutionModel-connectedness";
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId())};
    }

    @Override
    protected void setupRelativeRates() {
        for (int i = 0; i < this.relativeRates.length; ++i) {
            this.relativeRates[i] = this.ratesParameter.getParameterValue(i) * this.rateIndicator.getParameterValue(i);
        }
    }

    @Override
    void normalize(double[][] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        int n2 = dArray2.length;
        for (n = 0; n < n2; ++n) {
            d += -dArray[n][n] * dArray2[n];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                dArray[n][i] = dArray[n][i] / d;
            }
        }
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public boolean isUsed() {
        return super.isUsed() && this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Stochastic search variable selection, reversible substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2009_BAYESIAN);
    }

    protected class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return SVSGeneralSubstitutionModel.this.getLogLikelihood();
        }
    }
}

