/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.LogNormalDistributionModel;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.List;

public class NormalNormalMeanGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String OPERATOR_NAME = "normalNormalMeanGibbsOperator";
    public static final String LIKELIHOOD = "likelihood";
    public static final String PRIOR = "prior";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("likelihood", new XMLSyntaxRule[]{new ElementRule(DistributionLikelihood.class)}), new ElementRule("prior", new XMLSyntaxRule[]{new ElementRule(DistributionLikelihood.class)})};

        @Override
        public String getParserName() {
            return NormalNormalMeanGibbsOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            DistributionLikelihood distributionLikelihood = (DistributionLikelihood)xMLObject.getChild(NormalNormalMeanGibbsOperator.LIKELIHOOD).getChild(DistributionLikelihood.class);
            DistributionLikelihood distributionLikelihood2 = (DistributionLikelihood)xMLObject.getChild(NormalNormalMeanGibbsOperator.PRIOR).getChild(DistributionLikelihood.class);
            if (!(distributionLikelihood2.getDistribution() instanceof NormalDistribution) && !(distributionLikelihood2.getDistribution() instanceof NormalDistributionModel) || !(distributionLikelihood.getDistribution() instanceof NormalDistributionModel) && !(distributionLikelihood.getDistribution() instanceof LogNormalDistributionModel)) {
                throw new XMLParseException("Gibbs operator assumes normal-normal model");
            }
            return new NormalNormalMeanGibbsOperator(distributionLikelihood, distributionLikelihood2.getDistribution(), d);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a operator on the mean parameter of a normal model with normal prior.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final LikelihoodType likelihoodType;
    private final Distribution likelihood;
    private final Distribution prior;
    private final List<Attribute<double[]>> dataList;
    private final Parameter meanParameter;
    private double pathParameter = 1.0;

    public NormalNormalMeanGibbsOperator(DistributionLikelihood distributionLikelihood, Distribution distribution, double d) {
        if (!(distribution instanceof NormalDistribution) && !(distribution instanceof NormalDistributionModel)) {
            throw new RuntimeException("Mean prior must be Normal");
        }
        this.likelihood = distributionLikelihood.getDistribution();
        this.likelihoodType = LikelihoodType.factory(this.likelihood);
        this.dataList = distributionLikelihood.getDataList();
        if (this.likelihood instanceof NormalDistributionModel) {
            this.meanParameter = (Parameter)((NormalDistributionModel)this.likelihood).getMean();
        } else if (this.likelihood instanceof LogNormalDistributionModel) {
            this.meanParameter = ((LogNormalDistributionModel)this.likelihood).getParameterization() == LogNormalDistributionModel.Parameterization.MEAN_STDEV ? ((LogNormalDistributionModel)this.likelihood).getMeanParameter() : ((LogNormalDistributionModel)this.likelihood).getMuParameter();
        } else {
            throw new RuntimeException("Likelihood must be Normal or log Normal");
        }
        this.prior = distribution;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public double doOperation() {
        double d = 1.0 / this.prior.variance();
        double d2 = this.prior.mean();
        double d3 = this.likelihoodType.getPrecision(this.likelihood);
        double d4 = 0.0;
        int n = 0;
        for (Attribute<double[]> attribute : this.dataList) {
            for (double d5 : attribute.getAttributeValue()) {
                d4 += this.likelihoodType.getData(d5);
                ++n;
            }
        }
        double d6 = d + this.pathParameter * d3 * (double)n;
        double d7 = (d * d2 + this.pathParameter * d3 * d4) / d6;
        this.meanParameter.setParameterValue(0, MathUtils.nextGaussian() / Math.sqrt(d6) + d7);
        return 0.0;
    }

    @Override
    public void setPathParameter(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid pathParameter value");
        }
        this.pathParameter = d;
    }

    public int getStepCount() {
        return 1;
    }

    private static enum LikelihoodType {
        NORMAL{

            @Override
            double getPrecision(Distribution distribution) {
                return 1.0 / distribution.variance();
            }

            @Override
            double getData(double d) {
                return d;
            }
        }
        ,
        LOGNORMAL{

            @Override
            double getPrecision(Distribution distribution) {
                if (distribution instanceof LogNormalDistributionModel) {
                    return ((LogNormalDistributionModel)distribution).getPrecision();
                }
                throw new RuntimeException("Not yet implemented!");
            }

            @Override
            double getData(double d) {
                return Math.log(d);
            }
        };


        abstract double getPrecision(Distribution var1);

        abstract double getData(double var1);

        public static LikelihoodType factory(Distribution distribution) {
            if (distribution instanceof LogNormalDistributionModel) {
                return LOGNORMAL;
            }
            return NORMAL;
        }
    }
}

