## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>", 
  eval = FALSE
)

## -----------------------------------------------------------------------------
# usethis::edit_r_environ()
# 
# DATABRICKS_HOST = "Enter here your Workspace URL"
# DATABRICKS_TOKEN = "Enter here your personal token"

## -----------------------------------------------------------------------------
# library(sparklyr)
# con <- spark_connect(
#   cluster_id = "Enter here your cluster ID",
#   method = "databricks_connect"
# )
# con

## -----------------------------------------------------------------------------
# connection_is_open(con)

## -----------------------------------------------------------------------------
# library(dplyr)
# tbl(con, I("my_catalog.my_omop_schema.person"))

## -----------------------------------------------------------------------------
# tbl(con, I("my_catalog.my_omop_schema.person")) |>
#   head(5) |>
#   collect()

## -----------------------------------------------------------------------------
# spark_cars_df <- sdf_copy_to(con,
#                              cars,
#                              overwrite = TRUE)
# spark_cars_df

## ----eval=FALSE---------------------------------------------------------------
# library(OmopOnSpark)
# cdm <- cdmFromSpark(con,
#   cdmSchema = "my_catalog.my_omop_schema",
#   writeSchema = "my_catalog.my_results_schema",
#   writePrefix = "study_1_"
# )
# cdm

