/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.GeoSpatialDistribution;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;

public class GeoSpatialCollectionModel
extends AbstractModelLikelihood {
    private Parameter points;
    private List<GeoSpatialDistribution> geoSpatialDistributions;
    private int dim;
    private double[] cachedPointLogLikelihood;
    private double[] storedCachedPointLogLikelihood;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown;
    private double logLikelihood;
    private double storedLogLikelihood;
    private boolean[] validPointLogLikelihood;
    private boolean[] storedValidPointLogLikelihood;
    private final boolean isIntersection;

    public GeoSpatialCollectionModel(String string, Parameter parameter, List<GeoSpatialDistribution> list, boolean bl) {
        super(string);
        this.points = parameter;
        this.geoSpatialDistributions = list;
        this.dim = parameter.getDimension() / 2;
        this.cachedPointLogLikelihood = new double[this.dim];
        this.storedCachedPointLogLikelihood = new double[this.dim];
        this.validPointLogLikelihood = new boolean[this.dim];
        this.storedValidPointLogLikelihood = new boolean[this.dim];
        this.likelihoodKnown = false;
        this.addVariable(parameter);
        this.isIntersection = bl;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.validPointLogLikelihood[n / 2] = false;
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.cachedPointLogLikelihood, 0, this.storedCachedPointLogLikelihood, 0, this.dim);
        System.arraycopy(this.validPointLogLikelihood, 0, this.storedValidPointLogLikelihood, 0, this.dim);
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        double[] dArray = this.cachedPointLogLikelihood;
        this.cachedPointLogLikelihood = this.storedCachedPointLogLikelihood;
        this.storedCachedPointLogLikelihood = dArray;
        boolean[] blArray = this.validPointLogLikelihood;
        this.validPointLogLikelihood = this.storedValidPointLogLikelihood;
        this.storedValidPointLogLikelihood = blArray;
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (this.likelihoodKnown) {
            return this.logLikelihood;
        }
        this.logLikelihood = 0.0;
        double[] dArray = new double[2];
        for (int i = 0; i < this.dim; ++i) {
            if (!this.validPointLogLikelihood[i]) {
                int n = i * 2;
                for (int j = 0; j < 2; ++j) {
                    dArray[j] = this.points.getParameterValue(n + j);
                }
                double d = 0.0;
                for (GeoSpatialDistribution geoSpatialDistribution : this.geoSpatialDistributions) {
                    if (!this.isIntersection && !geoSpatialDistribution.getOutside()) {
                        double d2 = geoSpatialDistribution.logPdf(dArray);
                        if (d2 != Double.NEGATIVE_INFINITY) {
                            d = d2;
                            break;
                        }
                        d = d2;
                        continue;
                    }
                    if ((d += geoSpatialDistribution.logPdf(dArray)) != Double.NEGATIVE_INFINITY) continue;
                    break;
                }
                this.cachedPointLogLikelihood[i] = d;
                this.validPointLogLikelihood[i] = true;
            }
            this.logLikelihood += this.cachedPointLogLikelihood[i];
            if (this.logLikelihood == Double.NEGATIVE_INFINITY) break;
        }
        this.likelihoodKnown = true;
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        for (int i = 0; i < this.dim; ++i) {
            this.validPointLogLikelihood[i] = false;
        }
    }

    public Parameter getParameter() {
        return this.points;
    }
}

